/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime;

import java.util.Map;
import java.util.Iterator;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbCMPFinder;
import com.sun.enterprise.deployment.runtime.PrefetchDisabledDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.ResourcePrincipal;

/**
 * This node handles the cmp runtime deployment descriptors 
 *
 * @author  Jerome Dochez
 * @version 
 */
public class CmpNode extends DeploymentDescriptorNode {

    protected IASEjbCMPEntityDescriptor descriptor=null;
    
    /** Creates new CmpNode */
    public CmpNode() {
        registerElementHandler(new XMLElement(RuntimeTagNames.FINDER), FinderNode.class);   
        registerElementHandler(new XMLElement(RuntimeTagNames.PREFETCH_DISABLED), PrefetchDisabledNode.class);   
    }
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (descriptor == null) {
            Object desc = getParentNode().getDescriptor();
            if (desc instanceof IASEjbCMPEntityDescriptor) {
                descriptor = (IASEjbCMPEntityDescriptor) desc;            
            }
        }
        return descriptor;
    }
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {  
	Map dispatchTable = super.getDispatchTable();
	dispatchTable.put(RuntimeTagNames.MAPPING_PROPERTIES, "setMappingProperties");
        // deprecated element, will be ignored at reading
        dispatchTable.put(RuntimeTagNames.IS_ONE_ONE_CMP, null);
	return dispatchTable;
    }
    
    /**
     * Adds  a new DOL descriptor instance to the descriptor instance associated with 
     * this XMLNode
     *
     * @param descriptor the new descriptor
     */    
    public void addDescriptor(Object newDescriptor) {    
        getDescriptor();
        if (newDescriptor instanceof IASEjbCMPFinder ) {
            descriptor.addOneOneFinder((IASEjbCMPFinder ) newDescriptor);
        }
         else if (newDescriptor instanceof PrefetchDisabledDescriptor) {
            descriptor.setPrefetchDisabledDescriptor((PrefetchDisabledDescriptor)newDescriptor);
        } else super.addDescriptor(descriptor);        
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, IASEjbCMPEntityDescriptor ejbDescriptor) {    
	Node cmpNode = super.writeDescriptor(parent, nodeName, ejbDescriptor);
	appendTextChild(cmpNode, RuntimeTagNames.MAPPING_PROPERTIES, ejbDescriptor.getMappingProperties());
	Map finders = ejbDescriptor.getOneOneFinders();
	if (!finders.isEmpty()) {
	    Node findersNode = appendChild(cmpNode, RuntimeTagNames.ONE_ONE_FINDERS);
	    FinderNode fn = new FinderNode();
	    for (Iterator finderIterator = finders.values().iterator();finderIterator.hasNext();) {
		IASEjbCMPFinder aFinder = (IASEjbCMPFinder) finderIterator.next();
		fn.writeDescriptor(findersNode, RuntimeTagNames.FINDER, aFinder);
	    }
	}
        
        // prefetch-disabled
        PrefetchDisabledDescriptor prefetchDisabledDesc = 
            ejbDescriptor.getPrefetchDisabledDescriptor();             
        if (prefetchDisabledDesc != null) {
            PrefetchDisabledNode prefetchDisabledNode = 
                new PrefetchDisabledNode();
            prefetchDisabledNode.writeDescriptor(cmpNode, 
                RuntimeTagNames.PREFETCH_DISABLED, prefetchDisabledDesc);
        }

	return cmpNode;
    }
}
