/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
 * This class is responsible for handling the runtime resource
 * adapter configuration for the message-driven bean
 *
 * @author  Qingqing Ouyang
 * @version 
 */
public class MDBResourceAdapterNode extends DeploymentDescriptorNode {

    public MDBResourceAdapterNode() {
        registerElementHandler(
                new XMLElement(RuntimeTagNames.ACTIVATION_CONFIG),
                ActivationConfigNode.class);
                //"setRuntimeActivationConfigDescriptor");
    }
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        return getParentNode().getDescriptor();
    }        
    
   
    /**
     * all sub-implementation of this class can use a dispatch table to 
     * map xml element to method name on the descriptor class for setting 
     * the element value. 
     *  
     * @return the map with the element name as a key, the setter method 
     *         as a value
     */
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table =  new HashMap();
        table.put(RuntimeTagNames.RESOURCE_ADAPTER_MID, "setResourceAdapterMid");
        return table;
    }    
    
    /**
     * write the ejbmessage descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor( Node parent, 
            String nodeName, EjbMessageBeanDescriptor descriptor) {

        Node raNode = super.writeDescriptor(parent, nodeName, descriptor);
        appendTextChild(raNode, RuntimeTagNames.RESOURCE_ADAPTER_MID, 
                descriptor.getResourceAdapterMid()); 

        ActivationConfigNode activationConfigNode = new ActivationConfigNode();
        activationConfigNode.writeDescriptor
            (raNode, RuntimeTagNames.ACTIVATION_CONFIG,
             descriptor.getRuntimeActivationConfigDescriptor());
        return raNode;
    }
}
