/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime.common;

import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.runtime.common.ResourceRef;
import com.sun.enterprise.deployment.runtime.common.DefaultResourcePrincipal;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
 * This node handles all the role mapping information
 *
 * @author  Jerome Dochez
 * @version 
 */
public class ResourceRefNode extends RuntimeDescriptorNode {
    
    public ResourceRefNode() {
	registerElementHandler(new XMLElement(RuntimeTagNames.DEFAULT_RESOURCE_PRINCIPAL), 
				DefaultResourcePrincipalNode.class, "setDefaultResourcePrincipal"); 	
    }

    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {    
        Map table = super.getDispatchTable();
        table.put(RuntimeTagNames.RES_REF_NAME, "setResRefName");
        table.put(RuntimeTagNames.JNDI_NAME, "setJndiName");
        return table;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, ResourceRef descriptor) {  
        Node refNode = appendChild(parent, nodeName);
	appendTextChild(refNode, RuntimeTagNames.RES_REF_NAME, descriptor.getResRefName());
	appendTextChild(refNode, RuntimeTagNames.JNDI_NAME, descriptor.getJndiName());
	DefaultResourcePrincipal defaultPrincipal = descriptor.getDefaultResourcePrincipal();
	if (defaultPrincipal!=null) {
	    DefaultResourcePrincipalNode subNode = new DefaultResourcePrincipalNode();
	    subNode.writeDescriptor(refNode, RuntimeTagNames.DEFAULT_RESOURCE_PRINCIPAL, defaultPrincipal);
	}
        return refNode;
    }    
}
