/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.web;

import java.util.Map;
import java.util.Enumeration;
import org.w3c.dom.Node;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.JspConfigDescriptor;
import com.sun.enterprise.deployment.TagLibConfigurationDescriptor;
import com.sun.enterprise.deployment.JspGroupDescriptor;
import com.sun.enterprise.deployment.xml.WebTagNames;

/**
 * This node represents the <jsp-config> element in a web application.
 */
public class JspConfigNode extends DeploymentDescriptorNode {
    public JspConfigNode() {
	super();
	registerElementHandler(new XMLElement(WebTagNames.TAGLIB), TagLibNode.class, "addTagLib");
	registerElementHandler(new XMLElement(WebTagNames.JSP_GROUP), JspGroupNode.class, "addJspGroup");
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, JspConfigDescriptor descriptor) {    
	Node myNode = appendChild(parent, nodeName);
	TagLibNode lNode = new TagLibNode();
	for(Enumeration en = descriptor.getTagLibs(); en.hasMoreElements();) {
	    lNode.writeDescriptor(myNode, WebTagNames.TAGLIB, 
		(TagLibConfigurationDescriptor) en.nextElement());
	}
	JspGroupNode jspGroup = new JspGroupNode();
	for(Enumeration en = descriptor.getJspGroups(); en.hasMoreElements();) {
	    jspGroup.writeDescriptor(myNode, WebTagNames.JSP_GROUP, 
		(JspGroupDescriptor) en.nextElement());
	}

        return myNode;
    }
}
