/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime;

import java.util.*;
import java.lang.reflect.*;
import java.util.logging.*;
import javax.ejb.EJBException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.TypeUtil;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.util.DOLUtils;


/** 
 * This class contains information about the persistent state
 * (abstract persistence schema)
 * for EJB2.0 CMP EntityBeans .
 *
 * @author Prashant Jamkhedkar
 */

public class IASPersistenceManagerDescriptor extends Descriptor {
    
    public static final String PM_IDENTIFIER_DEFAULT = "SunOne"; // NOI18N
    public static final String PM_VERSION_DEFAULT = "1.0"; // NOI18N
    public static final String PM_CONFIG_DEFAULT = "myconfig.config";
    public static final String PM_CLASS_GENERATOR_DEFAULT = "com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGenerator"; // NOI18N
    public static final String PM_CLASS_GENERATOR_DEFAULT_OLD = "com.iplanet.ias.persistence.internal.ejb.ejbc.JDOCodeGenerator"; //NOI18N
    public static final String PM_MAPPING_FACTORY_DEFAULT = "com.sun.ffj.MyFactory"; // NOI18N
    private String pm_identifier = null;
    private String pm_version = null;
    private String pm_config = null;
    private String pm_class_generator = null;
    private String pm_mapping_factory = null;
    
    private static LocalStringManagerImpl localStrings =
	    new LocalStringManagerImpl(IASPersistenceManagerDescriptor.class);
    
    private static final Logger _logger = DOLUtils.getDefaultLogger();

    private Descriptor parentDesc; //the bean whose persistence I describe


    public IASPersistenceManagerDescriptor() {
       pm_identifier = PM_IDENTIFIER_DEFAULT;
       pm_version = PM_VERSION_DEFAULT;
       pm_config = PM_CONFIG_DEFAULT;
       pm_class_generator = PM_CLASS_GENERATOR_DEFAULT;
       pm_mapping_factory = PM_MAPPING_FACTORY_DEFAULT;
       _logger.finer("***IASPersistenceManagerDescriptor.constructed done -#-");	              
    }
    
    /** 
     * The copy constructor.
     */
    public IASPersistenceManagerDescriptor(String id, String ver, String conf, String generator, String factory) {
    
       pm_identifier = id;
       pm_version = ver;
       pm_config = conf;
       pm_class_generator = generator;
       pm_mapping_factory = factory;

       _logger.finer("***IASPersistenceManagerDescriptor.constructed done -#-");	       
    }

    public String getPersistenceManagerIdentifier() {
      return pm_identifier;
    }
    
    public void setPersistenceManagerIdentifier(String pm_identifier) {
        if (pm_identifier == null) {
            this.pm_identifier = PM_IDENTIFIER_DEFAULT;
        } else {
            this.pm_identifier = pm_identifier;
        }
    }
    
    public String getPersistenceManagerVersion() {
      return pm_version;
    }
    
    public void setPersistenceManagerVersion(String pm_version) {
        if (pm_version == null) {
            this.pm_version = PM_VERSION_DEFAULT;
        } else {
            this.pm_version = pm_version;
        }
    }
    
    public String getPersistenceManagerConfig () {
      return pm_config;
    }
    
    public void setPersistenceManagerConfig(String pm_config) {
        if (pm_config == null) {
            this.pm_config = PM_CONFIG_DEFAULT;
        } else {
            this.pm_config = pm_config;
        }
    }    
    
    public String getPersistenceManagerClassGenerator() {
      return pm_class_generator;
    }
    
    public void setPersistenceManagerClassGenerator(String pm_class_generator) {
        if (pm_class_generator == null) {
            this.pm_class_generator = PM_CLASS_GENERATOR_DEFAULT;
        } else {
            this.pm_class_generator = pm_class_generator;
        }
    }
    
    public String getPersistenceManagerMappingFactory() {
      return pm_mapping_factory;
    }
    
    public void setPersistenceManagerMappingFactory(String pm_mapping_factory) {
        if (pm_mapping_factory == null) {
            this.pm_mapping_factory = PM_MAPPING_FACTORY_DEFAULT;
        } else {
            this.pm_mapping_factory = pm_mapping_factory;
        }
    }

    /**     
     * Called from EjbCMPEntityDescriptor
     * when some classes in this object are updated.
     */         
    public boolean classesChanged() {
        return false;
    }
    
} // Class
