/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.util;

import java.util.Iterator;

import com.sun.enterprise.deployment.Application;

/**
 * This interface defines a cisitor API for the Application related DOL descriptors
 *
 * @author  Jerome Dochez
 * @version 
 */
public interface ApplicationVisitor {
    
    /**
     * visit an application object
     * @param the application descriptor
     */
    public void accept(Application application);
    
    /**
     * @return an implementation of the ejbBundleVisitor (if any)
     * to visit ejb bundle descriptors
     */
    public EjbBundleVisitor getEjbBundleVisitor();        

    /**
     * @return an implementation of the ConnectorVisitor (if any)
     * to visit connector descriptors
     */
    public ConnectorVisitor getConnectorVisitor();        
    
    /**
     * @return an implementation of the webBundleVisitor (if any)
     * to visit web bundle descriptors
     */
    public WebBundleVisitor getWebBundleVisitor();

    /**
     * @return an implementation of the AppClientVisitor (if any)
     * to visit app client descriptors
     */
    public AppClientVisitor getAppClientVisitor();

}

