/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security;

import java.security.Permission;
import com.sun.enterprise.security.CachedPermission;
import com.sun.enterprise.security.PermissionCache;
/**
 * This class is 
 * @author Ron Monzillo
 */

public class CachedPermissionImpl extends Object implements CachedPermission {

    PermissionCache permissionCache;
    Permission permission;
    boolean granted;
    Epoch epoch;

    public CachedPermissionImpl(PermissionCache c, Permission p) {
	this.permissionCache = c;
	this.permission = p;
	epoch = new Epoch();
    }

    public Permission getPermission() {
	return this.permission;
    }

    public PermissionCache getPermissionCache() {
	return this.permissionCache;
    }

    //synchronization done in PermissionCache
    public boolean checkPermission() {
	boolean granted = false;
	if (permissionCache != null) {
	    granted = permissionCache.checkPermission(this.permission,this.epoch);
	}
	return granted;
    }

    // used to hold last result obtained from cache and cache epoch.
    // epoch is used by PermissionCache to determine when result is out of date.
    class Epoch {

	int epoch;
	boolean granted;

	Epoch() {
	    this.epoch = 0;
	    this.granted = false;
	}
    }

}



