/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.util;

import java.io.Serializable;

/**
 * Represents a block of unique numbers reserved for a particular
 * context by the backend value generator.  This class should
 * only be used internally by concrete UniqueValueGenerator implementations.
 * 
 * @author Kenneth Saks
 */
public class UniqueValueBlock implements Serializable {
    
    // Lowest value available
    private long start_;
    
    // Number of values available in this block
    private long extent_;

    // Current value
    private long current_;

    /**
     * Use package-level access since this class should only be
     * used internally by concrete instances of UniqueValueGenerator.
     * The extent value must be >= 1.
     */
    UniqueValueBlock(long start, long extent) {
        start_   = start;
        extent_  = extent;
        current_ = start;
    }
    
    public synchronized boolean hasNext() {
        return (current_ < (start_ + extent_));
    }

    public synchronized long next() {
        if( !hasNext() ) {
            throw new IllegalStateException();
        }
        long returnValue = current_;
        current_++;
        return returnValue;
    }
}
