/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

//NOTE: Tabs are used instead of spaces for indentation. 
//  Make sure that your editor does not replace tabs with spaces. 
//  Set the tab length using your favourite editor to your 
//  visual preference.

/*
 * Filename: Bucket.java	
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of iPlanet/Sun Microsystems, Inc. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license 
 * agreement you entered into with iPlanet/Sun Microsystems.
 */
 
/**
 * <BR> <I>$Source: /cvs/glassfish/appserv-commons/src/java/com/sun/enterprise/util/collection/Bucket.java,v $</I>
 * @author     $Author: tcfujii $
 * @version    $Revision: 1.3 $ $Date: 2005/12/25 04:12:10 $
 */
 
package com.sun.enterprise.util.collection;

import java.util.Iterator;
	
/**
 * A bucket is esentially a list of entries that can be accessed through a primitive typed key.
 * Buckets are used in building primitive typed HashMaps. See IntHashMap for more details.
 * 
 */
public interface Bucket {
	
	/**
	 * Put an object into the bucket using the key. The key can be used
	 *	to retrieve the object later.
	 * @param key The key (can be negative).
	 * @param object The object to be put in the bucket.
	 * @return Any old object that was associated using the same key or null otherwise.
	 */
	public Object put(int key, Object object);
	public Object put(long key, Object object);
	
	/**
	 * Get an object into the bucket using the key.
	 * @param key The key (can be negative) for retrieving object.
	 * @return The object that was associated using the same key or null otherwise.
	 */
	public Object get(int key);
	public Object get(long key);
	
	/**
	 * Remove an object from the bucket using the key.
	 * @param key The key (can be negative).
	 * @return The object that was associated using the same key or null otherwise.
	 */
	public Object remove(int key);
	public Object remove(long key);
	
	/**
	 * Check if the bucket contains the key.
	 * @param key The key (can be negative).
	 * @return true if the bucket contains the key or null otherwise.
	 */
	public boolean containsKey(int key);
	public boolean containsKey(long key);
	
	
	/**
	 * Return the size of the bucket.
	 * @return The number of items in the bucket
	 */
	public int size();
	
	/**
	 * Get an iterator for iteraing through all objects in the bucket.
	 * @return An iterator. iterator.next() returns an object.
	 */
	public Iterator iterator();
	
	/**
	 * Get an iterator for iteraing through all entries in the bucket.
	 * @return An iterator. iterator.next() returns an IntEntry.
	 */
	public Iterator entryIterator();
	
}
