/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.util.collection;

public class IntSet {
    int[] members = new int[6];
    int size = 0;
    	
    public IntSet() {
    }
    	
	public boolean add(int value) {
		for (int i=0; i<size; i++) {
			if (members[i] == value) {
				return false;
			}
		}
			
		if (size == members.length) {
			int[] temp = new int[size + 4];
			System.arraycopy(members, 0, temp, 0, size);
			members = temp;
		}
		members[size++] = value;
		return true;
	}
	
	public boolean remove(int value) {
		for (int i=0; i<size; i++) {
			if (members[i] == value) {
				for (int j=i+1; j<size; j++) {
					members[j-1] = members[j];
				}
				return true;
			}
		}
		return false;
	}
			
	public boolean contains(int value) {
		for (int i=0; i<size; i++) {
			if (members[i] == value) {
				return true;
			}
		}
		return false;
	}
			
	
		
	public int size() {
		return size;
	}
		
	public int[] getMembers() {
		return members;
	}
    	
}
    
