/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LocalStringsManager.java
 *
 * Created on September 16, 2003
 */

package org.apache.tools.ant.taskdefs.optional.sun.appserv;

//imports
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.Properties;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.text.MessageFormat;

/**
 *  This is a utility class for getting localized string.
 *  Strings are stored in a single property file per package named
 *  LocalStrings[_locale].properties.
 *
 */
public class LocalStringsManager {
    
    private String packageName = "org.apache.tools.ant.taskdefs.optional.sun.appserv";
    private String propertyFile = "LocalStrings";
    private ResourceBundle resourceBundle = null;


    /** Creates a new instance of LocalStringsManager */
    public LocalStringsManager()
    {
        this.resourceBundle = ResourceBundle.getBundle(packageName + "." + propertyFile);
    }
    
    /*
     *returns the property file name
     */
    public String getPropertiesFile()
    {
        return propertyFile;
    }
    
    /*
     * returns the base package name
     */
    public String getPackageName()
    {
        return packageName;
    }
    
    /*
     *  Returns the Localized string properties file
     */
    public String getString(String key)
    {
        String value = "";
        try
        {
            value = resourceBundle.getString(key);
        }
        catch (MissingResourceException mre)
        {
            // if not found, try next resource bundle in the iterator
        }
        return value;
    }


    /*
     *  Return the Localized string with the inserted values
     */
    public String getString(String key, Object[] toInsert) 
    {
        String fmtStr = "";
        try
        {
            MessageFormat msgFormat = 
                            new MessageFormat(getString(key));
            fmtStr = msgFormat.format(toInsert);
        }
        catch(Exception e)
        {
        }
        return fmtStr;
    }
}
