/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.codegen;

import java.lang.reflect.Method;
import java.io.*;
import java.util.*;
import java.util.logging.*;
import com.sun.logging.*;
import com.sun.ejb.EJBUtils;

import com.sun.enterprise.util.LocalStringManagerImpl;

import static java.lang.reflect.Modifier.*;
import static com.sun.corba.ee.spi.codegen.Wrapper.*;
import com.sun.corba.ee.spi.codegen.Type;
import com.sun.corba.ee.impl.codegen.ClassGenerator;

/**
 * This class is used to generate a sub-interface of the
 * GenericEJBHome interface that will be loaded within each
 * application.
 */

public class GenericHomeGenerator extends Generator 
    implements ClassGeneratorFactory {

    private static LocalStringManagerImpl localStrings =
	new LocalStringManagerImpl(GenericHomeGenerator.class);
    private static Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.DPL_LOGGER);
    }

    private String genericEJBHomeClassName;
    private ClassLoader loader;

    /**
     * Get the fully qualified name of the generated class.
     * @return the name of the generated class.
     */
    public String getGeneratedClass() {
        return genericEJBHomeClassName;
    }

    // For corba codegen infrastructure
    public String className() {
        return getGeneratedClass();
    }

    public GenericHomeGenerator(ClassLoader cl)
	throws GeneratorException 
    {
	super();

        genericEJBHomeClassName = EJBUtils.getGenericEJBHomeClassName();
        loader = cl;
    }

    public ClassGenerator evaluate() {

        _clear();

        String packageName = getPackageName(genericEJBHomeClassName);
        String simpleName = getBaseName (genericEJBHomeClassName);

        _package(packageName);

        _interface(PUBLIC, simpleName, 
                   _t("com.sun.ejb.containers.GenericEJBHome"));

        _method(PUBLIC | ABSTRACT, _t("java.rmi.Remote"),
                "create", _t("java.rmi.RemoteException"));

        _arg(_String(), "generatedBusinessIntf");

        _end();

        _end();

        return _classGenerator() ;
    }

    public void generate(OutputStream out)
	throws GeneratorException, IOException 
    {
        throw new IllegalStateException("not supported");
    }

}
