/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.lang.reflect.Method;

import javax.ejb.EJBException;
import java.rmi.RemoteException;

public final class InvocationHandlerUtil {

    InvocationHandlerUtil() {}

    static Object invokeJavaObjectMethod(InvocationHandler handler, 
                                         Method method, Object[] args) 
        throws EJBException {

        Object returnValue = null;

        // Can only be one of : 
        //     boolean java.lang.Object.equals(Object)
        //     int     java.lang.Object.hashCode()
        //     String  java.lang.Object.toString()
        //
        // Optimize by comparing as few characters as possible.

        switch( method.getName().charAt(0) ) {
            case 'e' :
                boolean result = false;
                if (args[0] != null) {
                    Object other = Proxy.isProxyClass(args[0].getClass()) ?
                            Proxy.getInvocationHandler(args[0]) : args[0];
                            result = handler.equals(other);
                }
                returnValue = new Boolean(result);
                break;
            case 'h' :
                returnValue = new Integer(handler.hashCode());
                break;
            case 't' :
                returnValue = handler.toString();
                break;
            default :
                throw new EJBException(method.getName());
        }

        return returnValue;
    }

    static boolean isDeclaredException(Throwable t,
                                       Class[] declaredExceptions) 
    {
        boolean declaredException = false;

        for(int i = 0; i < declaredExceptions.length; i++) {
            Class next = declaredExceptions[i];
            if( next.isAssignableFrom(t.getClass()) ) {
                declaredException = true;
                break;
            }
        }

        return declaredException;
    }

    static void throwLocalException(Throwable t, 
                                    Class[] declaredExceptions) 
        throws Throwable 
    {
        Throwable toThrow = t;

        if( (t instanceof java.lang.RuntimeException) ||
            (isDeclaredException(t, declaredExceptions)) ) {
            toThrow = t;
        } else {
            toThrow = new EJBException();
            toThrow.initCause(t);
        } 
        
        throw toThrow;

    }

    static void throwRemoteException(Throwable t,
                                     Class[] declaredExceptions)
        throws Throwable 
    {
        Throwable toThrow = t;

        if( (t instanceof java.lang.RuntimeException) ||
            (t instanceof java.rmi.RemoteException) ||
            (isDeclaredException(t, declaredExceptions)) ) {
            toThrow = t;
        } else {
            toThrow = new RemoteException("", t);
        }

        throw toThrow;        
    }
}
