/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.util.*;
import javax.transaction.*;
import javax.transaction.xa.*;
import com.sun.enterprise.*;


/**
 * A "wrapper" implementation of javax.transaction.Transaction
 * used by the container to communicate with the PersistenceManager.
 * The PM can only call getStatus, registerSynchronization, setRollbackOnly
 * methods. The Synchronization objects registered by the PM must be
 * called AFTER the Synchronization objects registered by the container,
 * to ensure that all ejbStores are called before the PM flushes state to 
 * the database.
 *
 */

public class PMTransactionImpl implements Transaction {

    private Transaction tx;

    PMTransactionImpl(Transaction tx)
    {
	this.tx = tx;
    }
    
    public int getStatus() throws SystemException {
	return tx.getStatus();
    }

   
    public void registerSynchronization(Synchronization pmsync) 
        throws RollbackException, IllegalStateException,
        SystemException {

	// to make sure ejbStores are called before pmsync.beforeCompletion
	Switch theSwitch = Switch.getSwitch();
	ContainerFactoryImpl cf = (ContainerFactoryImpl)theSwitch.getContainerFactory();
	cf.getContainerSync(tx).addPMSynchronization(pmsync);	
    }


    public void setRollbackOnly() 
        throws IllegalStateException, SystemException {

	tx.setRollbackOnly();
    }            

    public boolean equals(Object object) {
        if (object == this)
            return true;
        else if ( !(object instanceof PMTransactionImpl) )
            return false;
        else
            return tx.equals(((PMTransactionImpl)object).tx);
    }

    public int hashCode() {
        return tx.hashCode();
    }
 

    public void commit() throws RollbackException, 
	HeuristicMixedException, HeuristicRollbackException,
        SecurityException, SystemException
    {
        throw new IllegalStateException("Operation not allowed");
    }


    public void rollback() 
        throws IllegalStateException, SystemException {
        
        throw new IllegalStateException("Operation not allowed");
    }

    public boolean enlistResource(XAResource res)
        throws RollbackException, IllegalStateException,
            SystemException {

        throw new IllegalStateException("Operation not allowed");
    }

    public boolean delistResource(XAResource res, int flags)
        throws IllegalStateException, SystemException {

        throw new IllegalStateException("Operation not allowed");
    }


}
