/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.io.Serializable;
import java.util.Date;

import javax.ejb.EJBLocalObject;

/**
 * Local view of the persistent representation of an EJB timer.
 *
 * @author Kenneth Saks
 */
public interface TimerLocal extends EJBLocalObject {

    /**
     * Accessors for read-only state.
     */ 

    /**
     * When timer was created.  Informational only.
     */
    Date getCreationTime();

    /**
     * Time of first timer expiration.
     */
    Date getInitialExpiration();


    /**
     * For periodic timers, number of milli-seconds between
     * timeouts.  0 for single-action timers.
     */
    long getIntervalDuration();

    /**
     * ejb container corresponding to timed object that created timer.
     */
    long getContainerId();

    /**
     * Id of server instance that owns timer.
     */
    String getOwnerId();

    /**
     * Application info associated with timer.  Can be null.
     * 
     */
    Serializable getInfo();    

    /**
     * Holds primary key for entity timed object. Null otherwise.
     */ 
    Object getTimedObjectPrimaryKey();

    /**
     * Mutable fields.
     */ 

    /**
     * This is the last time that a timer expiration completed
     * successfully or null if this field has not been set.
     */
    Date getLastExpiration();

    /**
     * This is the last time that a timer expiration completed
     * successfully or null to clear this value.
     */
    void setLastExpiration(Date lastExpiration);

    /**
     * Changes timer owner.  Typically done during timer migration.
     */ 
    void setOwnerId(String ownerId);

    /**
     * Operations.
     */ 

    /**
     * True if interval timer.  False if single-action timer.
     */
    boolean repeats();

    /**
     * Check if timer is in an active state.
     */
    boolean isActive();

    /**
     * Check if timer is in a cancelled state.
     */
    boolean isCancelled();
    
    /**
     * Cancel timer.
     */
    void cancel() throws Exception;

}
