/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers.util.cache;

import java.io.*;
import java.util.*;
import java.util.ArrayList;


public interface Cache {

    public Object get(Object key);
    
    public Object put(Object key, Object obj);
    
    public Object remove(Object key);
    
    public boolean contains(Object key);
    
    public Enumeration elements();
    
    public void clear();
    
    public int size();
    
    public int getMaxCacheSize();
    
    public int getCacheHits();
    
    public int getCacheMisses();
    
    public void incrementCacheFailures(Object key);
    
    public void incrementCacheSuccess(Object key);
    
    public void incrementCacheFailures();
    
    public void incrementCacheSuccess();
    
    /**
     * Destroys this cache. This method should perform final clean ups.
     */
    public void destroy();

}

