/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/ejb/containers/util/pool/Pool.java,v $</I>
 * @author     $Author: tcfujii $
 * @version    $Revision: 1.3 $ $Date: 2005/12/25 04:13:35 $
 */
 
package com.sun.ejb.containers.util.pool;

/**
 * Pool defines the methods that can be used by the application to access 
 * pooled objects. The basic assumption is that all objects in the pool are 
 * identical (homogeneous). This interface defines methods for a) getting an
 * object from the pool, b) returning an object back to the pool 
 * and, c) destroying (instead of reusing) an object. In addition to these 
 * methods, the Pool has methods for adding and removing PoolEventListeners.
 * There are six overloaded methods for getting objects from a pool.
 *	
 */
public interface Pool {
    
    /**
       @deprecated  
    */
    public Object getObject(boolean canWait, Object param)
        throws PoolException;
    
    /**
       @deprecated  
    */
    public Object getObject(long maxWaitTime, Object param)
        throws PoolException;
    
    /**
     * Get an object from the pool within the specified time.
     * @param The amount of time the calling thread agrees to wait.
     * @param Some value that might be used while creating the object
     * @return an Object or null if an object could not be returned in 
     *   'waitForMillis' millisecond.
     * @exception Throws PoolException if an object cannot be created
     */
    public Object getObject(Object param)
        throws PoolException;

    /**
     * Return an object back to the pool. An object that is obtained through
     *	getObject() must always be returned back to the pool using either 
     *	returnObject(obj) or through destroyObject(obj).
     */
    public void returnObject(Object obj);
    			
    /**
     * Destroys an Object. Note that applications should not ignore the 
     * reference to the object that they got from getObject(). An object
     * that is obtained through getObject() must always be returned back to
     * the pool using either returnObject(obj) or through destroyObject(obj).
     * This method tells that the object should be destroyed and cannot be
     * reused.
     *	
     */
    public void destroyObject(Object obj);
    	
}
