/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.sfsb;


/**
 * SFSBManagerConstants defines a set of "keys"
 * that can be used to populate / query values that
 * will be needed during SFSBManager creation.
 * 
 * @author Mahesh Kannan
 */
public interface SFSBStoreManagerConstants {

    /**
     * Name of the store manager. Used mainly for logging / debugging
     */
    public static String STORE_MANAGER_NAME =
        "com.sun.ejb.spi.sfsb.store.manager.name";

    /**
     * The unique prefix essentially contains some bits that
     *  is unique across VMs. For example, this can contain,
     *  in a clustered environment, a clusterID, nodeID etc.
     *  The prefix can be used to generate clusterwide unique
     *  session IDs.
     */
    public static String UNIQUE_PREFIX =
        "com.sun.ejb.spi.sfsb.unique.prefix";

    /**
     * The session group essentially contains some bits that
     *  can be used to group sessions. For example, this can
     *  contain the beanID (appID-moduleID-ejbID).
     *  The session group can be used to perform operations
     *  that affect all sessions for this bean
     */
    public static String SESSION_GROUP =
        "com.sun.ejb.spi.sfsb.session.group";

    /**
     * Defines the session timeout in seconds. Sessions not accessed
     *  for this duration can be removed and will no longer
     *  be available to clients
     */
    public static String SESSION_TIMEOUT_IN_SECONDS =
        "com.sun.ejb.spi.sfsb.session.timeout.in.seconds";

    /**
     * This will be used by File system sfsbManager
     *  This param could be null
     */
    public static String PASSIVATION_DIRECTORY_NAME =
        "com.sun.ejb.spi.sfsb.passivation.directory.name";


    /**
     * Defines the DataSource object that can be used to 
     *  obtained (possibly pooled) JDBC connections
     *  This will be used by StoreManagers that persists
     *  sessions using relational databases
     */
    public static String JDBC_DATASOURCE_INSTANCE =
        "com.sun.ejb.spi.sfsb.jdbc.datasource.instance";


    /**
     * Class Loader for this app
     */
    public static String CLASS_LOADER =
	"com.sun.ejb.spi.sfsb.classloader";

}
