/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common.domains.registry;
import java.io.Serializable;
import java.lang.CloneNotSupportedException;

/**
   Instances of this class represent the minimum data needed to
   contact an adminstration server remotely.
   <p>
   Instances of this class are immutable.
   @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
   @version $Revision: 1.3 $
*/


public class ContactData implements Cloneable, Serializable
{

	  /**
		 Construct an instance from the given arguments.
		 @param host the host name on which the admin server is
		 running.
		 @param port the port on which the admin server can be
		 contacted
		 @param useSSL indicate whether SSL should be used to contact
		 the admin server
		 @throws NullPointerException if either host or port are null
	  */
  public ContactData(String host,
					 String port,
					 boolean useSSL) throws NullPointerException {
	
	checkNull(host);
	this.host = host;
	checkNull(port);
	this.port = port;
	this.useSSL = useSSL;
  }

	  /**
		 Get the host of the receiver
		 @return the host of the receiver
	  */
  public String getHost(){
	return this.host;
  }

	  /**
		 Get the port of the receiver
		 @return the port of the receiver
	  */
  public String getPort(){
	return this.port;
  }
	/**
	   Indicate if ssl should be used to communicate to the admin server
	   @return true iff ssl should be used to communicate to the admin
	   server
	*/
  public boolean useSSL(){
	return this.useSSL;
  }

  public Object clone(){
	try {
	  return super.clone();
	}
	catch (CloneNotSupportedException e){ return null;}
  
  }

  public int hashcode(){
	final String s = host+port+(useSSL ? "t" : "f");
	return s.hashCode();
  }

  private void checkNull(String s) throws NullPointerException{
	if (s == null) {
	  throw new NullPointerException();
	}
  }
  
  private String host;
  private String port;
  private boolean useSSL;
}
