/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LogEventFactory.java
 *
 */

package com.sun.enterprise.admin.selfmanagement.event;

import javax.management.NotificationEmitter;
import javax.management.MBeanServer;
import javax.management.ObjectName;

import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.admin.selfmanagement.configuration.JavaBeanConfigurator;
import static com.sun.enterprise.admin.selfmanagement.event.ManagementRuleConstants.*;

/**
 *
 * This is the factory to build and configure LogEvent
 * @author hemanth
 */
public class LogEventFactory extends EventAbstractFactory{
    
    /** Creates a new instance of LogEventFactory */
    private LogEventFactory() {
        super();
        EventBuilder.getInstance().addEventFactory(EVENT_LOG, this);
    }
    
    public Event instrumentEvent(
            ElementProperty[] properties, String description ) {
        LogEventFilter filter = new LogEventFilter();
        filter = (LogEventFilter)JavaBeanConfigurator.getInstance().configureBean(
                filter, properties );
        LogEvent event = new LogEvent(filter,description);
        return event;
    }
    
    static LogEventFactory getInstance() {
        return instance;
    }
    
    
    private static LogEventFactory instance = new LogEventFactory();
    
}
