/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient;

import com.sun.enterprise.loader.EJBClassLoader;

/**
 *Class loader for use when the app client is launched via Java Web Start 
 *and the app client of interest depends on at least one persistence unit.
 *<p>
 
 * 
 * @author tjquinn
 */
public class AppClientJWSClassLoader extends EJBClassLoader{
    
    public AppClientJWSClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class result = findLoadedClass(name);
        if (result == null) {
            result = findClass(name);
            if (result == null) {
                super.loadClass(name, resolve);
            }
        }
        return result;
    }
}
