/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors;

import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.SerializableObjectRefAddr;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Reference;
import javax.naming.NamingException;

/**
 * Resource infor for Connector administered objects
 *
 * @author	Qingqing Ouyang
 */
public class AdministeredObjectResource extends J2EEResourceBase 
    implements Serializable {

    private String resadapter_;
    private String adminObjectClass_;
    private String adminObjectType_;
    private Set configProperties_;

    
    public AdministeredObjectResource (String name)
    {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        AdministeredObjectResource clone = 
            new AdministeredObjectResource(name);
        clone.setResourceAdapter(getResourceAdapter());
        clone.setAdminObjectType(getAdminObjectType());
        return clone;
    }


    public int getType() {
        // FIX ME 
        return 0;
        //return J2EEResource.ADMINISTERED_OBJECT;
    }

    public void initialize(AdminObject desc) {
        configProperties_ = desc.getConfigProperties();
        adminObjectClass_ = desc.getAdminObjectClass();
        adminObjectType_ = desc.getAdminObjectInterface();
    }

    public String getResourceAdapter() {
        return resadapter_;
    }

    public void setResourceAdapter(String resadapter) {
        resadapter_ = resadapter;
    }

    public String getAdminObjectType() {
        return adminObjectType_;
    }
    
    public void setAdminObjectType (String adminObjectType) {
        this.adminObjectType_ = adminObjectType;
    }

    public void setAdminObjectClass(String name) {
        this.adminObjectClass_ = name;
    }

    public String getAdminObjectClass() {
        return this.adminObjectClass_;
    }
    
    /*
     * Add a configProperty to the set
     */
    public void addConfigProperty(EnvironmentProperty configProperty)
    {
        this.configProperties_.add(configProperty);
    }

    /**
     * Add a configProperty to the set
     */
    public void removeConfigProperty(EnvironmentProperty configProperty)
    {
        this.configProperties_.remove(configProperty);
    }

    public Reference createAdminObjectReference() {
        Reference ref = 
            new Reference(getAdminObjectType(),
                    new SerializableObjectRefAddr("jndiName", this),
                    ConnectorConstants.ADMINISTERED_OBJECT_FACTORY, null);
        
        return ref;
    }


    // called by com.sun.enterprise.naming.factory.AdministeredObjectFactory
    // FIXME.  embedded??
    public Object createAdministeredObject(ClassLoader jcl)
        throws PoolingException {

        try {
            if (jcl == null) {
                // use context class loader
                jcl = (ClassLoader) AccessController.doPrivileged
                    (new PrivilegedAction() { 
                            public Object run() {
                                return 
                                    Thread.currentThread().getContextClassLoader();
                            }
                        });
            }
                
            
            Object adminObject = 
                jcl.loadClass(adminObjectClass_).newInstance();
            
            AccessController.doPrivileged
                (new SetMethodAction(adminObject, configProperties_));
            return adminObject;
        } catch (PrivilegedActionException ex) {
            throw (PoolingException) (new PoolingException().initCause(ex));
        } catch (Exception ex) {
            throw (PoolingException) (new PoolingException().initCause(ex));
        }

    }

    public String toString() {
        return "< Administered Object : " + getName() + 
            " , " + getResourceAdapter() +
            " , " + getAdminObjectType() + " >";
    }
}
