/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.backend;

import java.util.logging.Level;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.io.IOException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipItem;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.deployment.archivist.*;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;

public class AppClientModuleDeployer extends ModuleDeployer
{
    AppClientModuleDeployer(DeploymentRequest r) throws IASDeploymentException
    {
	super(r);
    }
    
    ///////////////////////////////////////////////////////////////////////////
    
    protected BaseManager createConfigManager(InstanceEnvironment ienv, ModuleEnvironment menv) 
    throws IASDeploymentException, ConfigException
    {
	return  new AppclientModulesManager(ienv);
    }
    
    ///////////////////////////////////////////////////////////////////////////
    
    protected void preDeploy() throws IASDeploymentException
    {
	assert moduleDir != null;
	assert StringUtils.ok(moduleName);
	
	try
	{
	    if(isRegistered()) {
		String msg = localStrings.getString(
		"enterprise.deployment.backend.deploy_error_module_exists");
		throw new IASDeploymentException( msg );
	    }
	    
	    // if the directories already exist on disk -- wipe them out
	    // We do this because otherwise they'd never get this Module deployed
	    // without wiping the dirs manually
	    liquidateModuleDirAndStubsDirIfTheyHappenToExist();
	    
	    if(request.isArchive()) {
		J2EEModuleExploder.explodeJar(request.getFileSource().getFile(), moduleDir);
	    }

	    xmlDir.mkdirs(); 
	    jwsDir.mkdirs(); 
	}
	catch(Exception e)
	{
	    throw new IASDeploymentException(e.toString(), e);
	}
    }
    
    protected boolean needsStubs()
    {
	// override this for any module that needs stubs created
	return true;
    }    
    
    ///////////////////////////////////////////////////////////////////////////
    
    protected void preRedeploy() throws IASDeploymentException, ConfigException
    {
	setOldDirs();
	
	if(request.isArchive())
	{
	    try
	    {
		J2EEModuleExploder.explodeJar(request.getFileSource().getFile(), moduleDir);
		
	    }
	    catch(IOException e)
	    {
		throw new IASDeploymentException(e.toString(), e);
	    }
	}

        xmlDir.mkdir();	
        jwsDir.mkdirs(); 
    }
    
    ///////////////////////////////////////////////////////////////////////////
        
    protected void deploy() throws IASDeploymentException, ConfigException
    {
        loadDescriptors();
        runVerifier();
        checkAppclientsMainClasses();
        xmlDir.mkdirs();
        // Set the generated XML directory in application desc
        request.getDescriptor().setGeneratedXMLDirectory(xmlDir.getAbsolutePath());
	ZipItem[] clientStubs = runEJBC();
	createClientJar(clientStubs);
    }
    
    
    ///////////////////////////////////////////////////////////////////////////
    

    
    private static StringManager localStrings =
    StringManager.getManager( AppClientModuleDeployer.class );
}

