/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentEventType.java
 *
 * Created on June 17, 2003, 12:38 PM
 * @author  sandhyae
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/enterprise/deployment/backend/DeploymentEventType.java,v $
 *
 */

package com.sun.enterprise.deployment.backend;


/**
 *
 * @author  Sandhya E
 */
public class DeploymentEventType {
     
    
    /** Creates a new instance of DeploymentEventType */
    private DeploymentEventType(String theName) {
        assert theName != null;
	name = theName;
    }
        
    ///////////////////////////////////////////////////////////////////////////
    
    public String toString() {
        return name;
    }
    
    //////////////////////////////////////////////////////////////////////////
    // Event types
    public	static final int PRE_DEPLOY		= 1;
    public	static final int POST_DEPLOY		= 2;

    public	static final int PRE_UNDEPLOY	        = 3;
    public	static final int POST_UNDEPLOY	        = 4;
   
    public	static final int PRE_ASSOCIATE		= 11;
    public	static final int POST_ASSOCIATE	   = 12;
    
    public	static final int PRE_APP_START	        = 5;
    public	static final int POST_APP_START	        = 6;
    
    public	static final int PRE_APP_STOP	        = 7;
    public	static final int POST_APP_STOP	        = 8;
    
    public	static final int PRE_DISASSOCIATE	= 9;
    public	static final int POST_DISASSOCIATE	= 10;    
    
    public      static final int PRE_RA_START          = 11;
    public      static final int POST_RA_START         = 12;

    public      static final int PRE_RA_STOP           = 13;
    public      static final int POST_RA_STOP          = 14;

    public      static final int PRE_RES_CREATE          = 15;
    public      static final int POST_RES_CREATE        = 16;

    public      static final int PRE_RES_DELETE           = 17;
    public      static final int POST_RES_DELETE          = 18;

    private final			String					name;
}
