/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.client;

import com.sun.enterprise.admin.jmx.remote.DefaultConfiguration;

/**
 * This class defines all necessary information to 
 * connect to a particular application server deployment
 * backend. 
 *
 * @author Jerome Dochez
 */
public class ServerConnectionIdentifier {
    
        /**
     * Holds value of property hostName.
     */
    private String hostName;
    
    /**
     * Holds value of property hostPort.
     */
    private int hostPort;
    
    /**
     * Holds value of property userName.
     */
    private String userName;
    
    /**
     * Holds value of property password.
     */
    private String password;
    
    /**
     * Holds value of property protocol.
     */
    private String protocol;

    private boolean secure = false;

    private ServerConnectionEnvironment env;
    
    /** Creates a new instance of ServerConnectionIdentifier */
    public ServerConnectionIdentifier() {
    }
    
    /**
     * Getter for property hostName.
     * @return Value of property hostName.
     */
    public String getHostName() {
        return this.hostName;
    }    
    
    /**
     * Setter for property hostName.
     * @param hostName New value of property hostName.
     */
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }    
    
    /**
     * Getter for property hostPort.
     * @return Value of property hostPort.
     */
    public int getHostPort() {
        return this.hostPort;
    }
    
    /**
     * Setter for property hostPort.
     * @param hostPort New value of property hostPort.
     */
    public void setHostPort(int hostPort) {
        this.hostPort = hostPort;
    }
    
    /**
     * Getter for property userName.
     * @return Value of property userName.
     */
    public String getUserName() {
        return this.userName;
    }
    
    /**
     * Setter for property userName.
     * @param userName New value of property userName.
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }
    
    /**
     * Getter for property password.
     * @return Value of property password.
     */
    public String getPassword() {
        return this.password;
    }

    /**
     * Setter for property password.
     * @param password New value of property password.
     */
    public void setPassword(String password) {
        this.password = password;
    }
    
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public ServerConnectionEnvironment getConnectionEnvironment() {
        if (env == null) {
            env = new ServerConnectionEnvironment();
        }
        return env;
    }

    public void setConnectionEnvironment(ServerConnectionEnvironment env) {
        this.env = env;
    }
    
    /**
     * Getter for property protocol.
     * the protocol can only be two values:
     * either DefaultConfiguration.S1_HTTPS_PROTOCOL, if secure
     * or DefaultConfiguration.S1_HTTP_PROTOCOL, if not secure
     * @return Value of property protocol.
     */
    public String getProtocol() {
        if (isSecure()) {
            return DefaultConfiguration.S1_HTTPS_PROTOCOL;
        } else {
            return DefaultConfiguration.S1_HTTP_PROTOCOL;
        }
    }
    
    /**
    * @return true if I am the equals to the other object
    */
    public boolean equals(Object other) {
        if (other instanceof ServerConnectionIdentifier) {
            ServerConnectionIdentifier dci = (ServerConnectionIdentifier) other;
            if (hostName==null) {
                return false;
            } else {
                if (!hostName.equals(dci.hostName))
                    return false;
            }
            if (hostPort!=dci.hostPort) {
                return false;
            }
            if (!getConnectionEnvironment().equals(dci.getConnectionEnvironment())) {
                return false;
            }
	    if (protocol==null) {
		return dci.protocol==null;
            } else { 
		return protocol.equals(dci.protocol);
            }
        } else {
            return false;
        }
    }     
    
    public String toString() {
        return getUserName()+"("+ getPassword()+")@(" + getHostName() 
            + "):(" + getHostPort()+")" + ":" + getProtocol();
    }
}
