/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.client.local;

import com.sun.appserv.management.util.jmx.MBeanServerConnectionConnectionSource;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployment.client.DeploymentFacilityImpl;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.deployment.client.TargetType;

import java.io.IOException;
import javax.enterprise.deploy.spi.Target;

/**
 * This extends DeploymentFacilityImpl and gives local clients
 * access to backend via a local connection
 *
 */
public class LocalDeploymentFacilityImpl extends DeploymentFacilityImpl {
    
    public LocalDeploymentFacilityImpl() {
        super();
    }
    
    /**
     * Connects to the local domain adminstration server
     */
    public boolean connect(ServerConnectionIdentifier targetDAS) {
        dasConnection = new MBeanServerConnectionConnectionSource(MBeanServerFactory.getMBeanServer());
        serverId = targetDAS;
        domain = new SunTarget(targetDAS);
        domain.setConnectionSource(dasConnection);
        domain.setTargetType(TargetType.DOMAIN);
        localConnection = Boolean.TRUE;
        return true;
    }
}
