/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics;

import java.util.Iterator;

/**
 * Represents a Diagnostic Data object. A data object may contain collection of
 * other data objects or collection of string items such as entries in 
 * domain.xml are retrieved using getValues. 
 * @author Manisha Umbarje
 */
public interface Data {
    
    /**
     * A data can be a composite data containing other data elements
     */
    public Iterator<Data> getChildren();
    
    /**
     * A data object may contain values as strings
     */
    public Iterator<String> getValues();
    
    /**
     *
     */
    public Iterator<Iterator<String>> getTable();
    
    /**
     * Source from where the Data Object is created. This could be name of the 
     * file which represents this Data Object.
     * @return source 
     */
    public String getSource();
    
    /** 
     * Every data object knows what type of data it contains.
     */
    public String getType();
    
    /**
     * Returns children of a specific type
     * @return 
     
    public Iterator<Data> getChildren(String type);
    
    /**
     * Returns child of specific type. It's assumed that there is only one
     * child with that type. No gurantee is provided if there are multiple
     * children of same type.
     
    public Data getChild(String type);
     */
    
}
