/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.logging.LogDomains;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;


import java.util.logging.Logger;
import java.util.logging.Level;
import java.io.File;

/**
 * Class to collect System Information for Windows OS
 */
public class WindowsSystemInfoCollector implements Collector{

    private static Logger logger =
            LogDomains.getLogger(LogDomains.ADMIN_LOGGER);

    /* Command for properties */
    private static final String MEMORY_INFO_CMD = "mem";
    private static final String IP_ADDRESS_INFO_CMD = "ipconfig";
    private static final String HOST_NAME_CMD = "hostname";
    private static final String OS_INFO_CMD = "ver";

    private String destFolder = null;


    public WindowsSystemInfoCollector(String destFolder){
        this.destFolder = destFolder;
    }

    /**
     * To capture the system information for Windows OS
     * @return  Data representing System Information
     */
    public Data capture(){

        FileData data = null;

        String outputFileName = destFolder + File.separator + Defaults.SYSTEM_INFO_FILE;

        final String ALL_CMDS =

                "(echo HOSTNAME & "+HOST_NAME_CMD+" & " +
                        "echo OS INFO & "+ OS_INFO_CMD +" & " +
                        "echo MEMORY INFO & " + MEMORY_INFO_CMD  + " & " +
        "echo IP ADDRESS & " + IP_ADDRESS_INFO_CMD + ") >> " + outputFileName ;


        String[] cmd = {"cmd.exe", "/C", ALL_CMDS};

        ProcessExecutor executor = new ProcessExecutor(cmd, 0);
        try{
        executor.execute();

        File outputFile = new File(outputFileName);

        data = new FileData(outputFile.getName(),DataType.SYSTEM_INFO);

        }
        catch(ProcessExecutorException pee){
            logger.log(Level.WARNING, "Exception while capturing system info" +
                     " : " + pee.getMessage());
        }
        
        return data;
    }
}
