/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.iiop;

import java.io.*;

public class HandleDelegateClassLoader
    extends ClassLoader
{
    
    public HandleDelegateClassLoader() {
        super();
    }
    
    protected Class findClass(String name)
        throws ClassNotFoundException
    {
        // This is called only if the class could not be loaded by
        // the parent class loader (see javadoc for loadClass methods).
        // Load the class from the current thread's context class loader.
        
        Class c =Thread.currentThread().getContextClassLoader().loadClass(name);
        
        return c;
    }
    
    protected Class loadClass(String name, boolean resolve)
        throws ClassNotFoundException
    {
        if (!name.equals("com.sun.enterprise.iiop.IIOPHandleDelegate")) {
            return super.loadClass(name, resolve);
        }
        
        Class handleDelClass = findLoadedClass(name);
        if (handleDelClass != null) {
            return handleDelClass;
        }
        
        try {
            // read the bytes for IIOPHandleDelegate.class
            ClassLoader resCl = Thread.currentThread().getContextClassLoader();
            if (Thread.currentThread().getContextClassLoader() == null)  {
                resCl = getSystemClassLoader();
            }
            InputStream is = resCl.getResourceAsStream("com/sun/enterprise/iiop/IIOPHandleDelegate.class");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            
            byte[] buf = new byte[4096]; // currently IIOPHandleDelegate is < 4k
            int nread = 0;
            while ( (nread = is.read(buf, 0, buf.length)) != -1 ) {
                baos.write(buf, 0, nread);
            }
            baos.close();
            is.close();

            byte[] buf2 = baos.toByteArray();
            
            handleDelClass = defineClass(
            "com.sun.enterprise.iiop.IIOPHandleDelegate",
            buf2, 0, buf2.length);
            
        } catch ( Exception ex ) {
            throw (ClassNotFoundException)new ClassNotFoundException(ex.getMessage()).initCause(ex);
        }
        
        if (resolve) {
            resolveClass(handleDelClass);
        }
        
        return handleDelClass;
    }
}
