/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ResourceDeployer.java
 *
 * Created on December 12, 2003, 12:35 PM
 */

package com.sun.enterprise.resource;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.serverbeans.ElementProperty;

/**
 *
 * @author  Rob Ruyak
 */
public abstract class GlobalResourceDeployer {
    
    /**
     * Gets the application server Switch object for accessing env. objects. 
     * This is an internal method created to eliminate dependency for other 
     * methods. This enables one to develop unit tests for this class.
     *
     * @return Switch singleton containing appserver runtime objects.
     */
    Switch getAppServerSwitchObject() {
        return Switch.getSwitch();
    }
    
    /**
     * Return an the element property names as an array of strings.
     *
     * @param props An array of ElementProperty objects.
     * @return The names within the element as an array of strings.
     */
    String[] getPropNamesAsStrArr(ElementProperty [] props) {
        if (props == null) { 
            return null; 
        } else {
            String [] result = new String[props.length];
            for(int i = 0; i < props.length; i++) {
                result[i] = props[i].getName();
            }
            return result;
        }
    }
    
    /**
     * Return an the element property values as an array of strings.
     *
     * @param props An array of ElementProperty objects.
     * @return The values within the element as an array of strings.
     */
    String[] getPropValuesAsStrArr(ElementProperty [] props) {
        if (props == null) { 
            return null; 
        } else {
            String [] result = new String[props.length];
            for(int i = 0; i < props.length; i++) {
                result[i] = props[i].getValue();
            }
            return result;
        }
    }
   
}
