/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security.acl;

import java.security.Principal;

/**
 * Abstract resource ..
 * @author Harish Prabandham
 */
abstract public class Resource {
	private String app;
	private String name;
	private String method;

	protected Resource(String app, String name, String method) {
		this.app = app;
		this.name = name;
		this.method = method;
	}

	public String getName() {
		return this.name;
	}

	public String getApplication() {
		return this.app;
	}

	public String getMethod() {
		return this.method;
	}

	public int hashCode() {
		return getClass().hashCode();
	}

	public abstract boolean implies(Resource res);
	public abstract boolean equals(Object obj);

	public String toString() {
		return getApplication() + ":" + getName() + "." + getMethod();
	}
}
