/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.audit;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.SecurityServiceEvent;
import com.sun.enterprise.admin.event.SecurityServiceEventListener;


/**
 * Listener interface to handle security service events.
 * In this moment, only audit-enabled flag can be updated dynamically.
 * @author Shing Wai Chan
 */
public class SecurityServiceEventListenerImpl implements SecurityServiceEventListener {

    /**
     * New security service element created.
     * It is called whenever a SecurityServiceEvent with action of
     * SecurityServiceEvent.ACTION_CREATE is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void securityServiceCreated(SecurityServiceEvent event)
             throws AdminEventListenerException {
    }

    /**
     * security service deleted.
     * It is called whenever a SecurityServiceEvent with action of
     * SecurityServiceEvent.ACTION_DELETE is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void securityServiceDeleted(SecurityServiceEvent event)
             throws AdminEventListenerException {
    }

    /**
     * security service element updated (attributes change).
     * It is called whenever a SecurityServiceEvent with action of
     * SecurityServiceEvent.ACTION_UPDATE is received.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void securityServiceUpdated(SecurityServiceEvent event)
             throws AdminEventListenerException {
        try {
            SecurityService securityBean =
                ServerBeansFactory.getSecurityServiceBean(
                event.getConfigContext());
            boolean auditFlag = securityBean.isAuditEnabled();

            SecurityService oldSecurityBean =
                ServerBeansFactory.getSecurityServiceBean(
                event.getOldConfigContext());

            boolean oldAuditFlag = oldSecurityBean.isAuditEnabled();

            if (auditFlag != oldAuditFlag) {
                AuditManagerFactory.getInstance().getAuditManagerInstance().setAuditOn(auditFlag);
            }
        } catch(Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

}
