/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * @(#) MonitorListener.java
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of iPlanet/Sun Microsystems, Inc. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license
 * agreement you entered into with iPlanet/Sun Microsystems.
 */
package com.sun.enterprise.server;

import java.io.File;

/**
 * This interface defines the methods that must be implemented by objects
 * that are interested in call backs from server runtime monitors.
 *
 * @author Nazrul Islam
 */
interface MonitorListener {
    
    /**
     * Callback from the reload monitor for this given entry.
     * This is done when user updates the $APP_ROOT/.reload file 
     * indicating the server runtime for a dynamic reload.
     * 
     * @param    entry    entry thats being monitored
     *
     * @return   true if application was reloaded successfully
     */
    boolean reload(MonitorableEntry entry);

    /**
     * Callback from the auto deploy monitor when a new archive is detected. 
     *
     * @param    entry    entry thats being monitored
     * @param    archive  newly detected archive under the auto deploy directory
     *
     * @return   true if archive was deployed successfully
     */
    boolean deploy(MonitorableEntry entry, File archive);
}
