/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.logging.diagnostics;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * Diagnostics class contains list of causes, diagnostic checks and the uri
 * to search for the latest and greatest diagnostics information based on
 * a message id. 
 *
 * @author Hemanth Puttaswamy
 */
public class Diagnostics {
    String messageId; 
    private ArrayList causes;
    private ArrayList checks;
    private String uri;

    public Diagnostics( String messageId ) {
        this.messageId = messageId;
        causes = new ArrayList();
        checks = new ArrayList();
    }

    public void addCause( String cause ) {
        causes.add( cause );
    }

    public void addCheck( String check ) {
        checks.add( check );
    }

    public void setPossibleCauses( ArrayList list ) {
        causes = list;
    }

    public void setDiagnosticChecks( ArrayList list ) {
        checks = list;
    }
 
    public void setURI( String uri ) {
        this.uri = uri;
    } 

    public String getMessageId( ) {
        return messageId;
    }

    public ArrayList getPossibleCauses( ) {
        return causes;
    }

    public ArrayList getDiagnosticChecks( ) {
        return checks;
    }

    public String getURI( ) {
        return uri;
    }

    /**
     * A Simple Debug print method to print the contents of this class.
     */
    public void print( ) {
        System.out.println( "---------------------------------" );
        System.out.println( "Diagnostics for MessageId = " + messageId );
        Iterator iterator = null;
        if( causes != null ) {
            iterator = causes.iterator( );
            System.out.println( "Causes --> " );
            while( iterator.hasNext( ) ) {
                System.out.println( iterator.next( ) );
            }
        }
        if( checks != null ) { 
            iterator = checks.iterator( );
            System.out.println( "Checks --> " );
            while( iterator.hasNext( ) ) {
                System.out.println( iterator.next( ) );
            }
        }
        System.out.println( "URI = " + uri );
        System.out.println( "---------------------------------" );
    }
}

