/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ondemand.entry;


/**
 * Defines an entrpoint to a servicegroup.
 *
 * @author Binod PG
 * @see ServerEntryListener.
 */
public interface EntryPoint {

    /* Specifies an entry via port */
    public final int PORT = 1;

    /* Specifies an entry via application */
    public final int APPLOADER = 2;

    /* Specifies an entry via a lookup */
    public final int JNDI = 3;

    /* Specifies an entry via an mbean  */
    public final int MBEAN = 4;

    /* Used mainly for switching off on-demand. This is a negative entry  */
    public final int STARTUP = 5;

    /**
     * Each entrypoint will generate an entry context and provide
     * it to the <code> ServerEntryListener </code>.
     */
    public void generateEntryContext(Object context);
}
