/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.pluggable;

import com.sun.enterprise.server.ss.*;
import com.sun.enterprise.pluggable.Utils;
import com.sun.enterprise.autotxrecovery.TransactionRecovery;

/**
 * Properties that define implementation classes for pluggable features
 * used for the PE (Platform Edition) version of S1AS. An instance of this class
 * should be passed to getInstance() method of PluggableFeatureFactoryImpl
 * to create and have access to pluggable features.
 */
public class PEPluggableFeatureImpl extends TomcatPluggableFeatureImpl {

    static {
        // Enable Quick startup. So we need to change the service list.
        featureImplClasses.setProperty(Utils.getNQClassName(ASLazyKernel.class),
	    "com.sun.enterprise.server.ss.ASLazyKernel");
        featureImplClasses.setProperty(Utils.getNQClassName(TransactionRecovery.class),
	    "com.sun.enterprise.server.TransactionRecoveryServicePEImpl");
    
    }

    /**
     * Default constructor. 
     */
    public PEPluggableFeatureImpl() {
        super();
    }

}
