/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ss;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import com.sun.enterprise.server.ss.spi.ASSocketServiceFacade;

/**
 * A Proxy that delegates to the actual ASSocketService class. This facade
 * is introduced to separate the implementation and interfaces of the 
 * Quickstartup/ASLazyKernel related classes
 * In the new classloader scheme, the actual implementation
 * of the ASLazyKernel would lie in appserv-rt.jar, and the SystemClasspath 
 * would have the interfaces classes alone. [NIO specific AS-implementation interfaces
 * would need to be in the system classpath as J2SE' NIO implmentation requires
 * them to be there]
 * Classes under the following packages are now placed under appserv-launch.jar
 * com.sun.enterprise.server.ss.provider 
 * com.sun.enterprise.server.ss.util
 * com.sun.enterprise.server.ss.spi
 *
 * @author Sivakumar Thyagarajan, Binod PG
 */
public class ASSocketServiceProxy implements ASSocketServiceFacade{

    public void clientSocketConnected(Socket s) {
        ASSocketService.clientSocketConnected(s);        
    }

    public boolean isServerStartingUp(int port) {
        return ASSocketService.isServerStartingUp(port);
    }

    public boolean close(int port, ServerSocket sock, ServerSocketChannel channel) throws IOException {
        return ASSocketService.close(port, sock, channel);
    }

    public void waitOnAccept(Socket s) {
        ASSocketService.waitOnAccept(s);
    }

    public boolean isLocalClient(Socket s) {
        return ASSocketService.isLocalClient(s);
    }

    public boolean exists(int port) {
        return ASSocketService.exists(port);
    }

    public void removeListeningSelector(int port) {
        ASSocketService.removeListeningSelector(port);
    }

    public void waitOnAccept(SocketChannel sc) {
        ASSocketService.waitOnAccept(sc);
    }

    public ServerSocketChannel getServerSocketChannel(int port) {
        return ASSocketService.getServerSocketChannel(port);
    }

    public ServerSocket getServerSocket(int port) {
        return ASSocketService.getServerSocket(port);
    }

    public boolean socketServiceNotified(int port) {
        return ASSocketService.socketServiceNotified(port);
    }

    public void waitOnClientConnection(Socket s) {
        ASSocketService.waitOnClientConnection(s);
    }
    
}
