/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.transaction;
import com.sun.enterprise.transaction.monitor.JTSMonitorMBean;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEvent;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;

import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;

public class TransactionsRecoveryEventListenerImpl implements  TransactionsRecoveryEventListener {
 
        // Sting Manager for Localization
    private static StringManager sm = StringManager.getManager(TransactionsRecoveryEventListenerImpl.class);


   /**
    * Recovers taransactions for given instance
    * @param event - TransactionsRecoveryEvent containing data to recovery
    *
    **/
   public void processEvent(TransactionsRecoveryEvent event) throws AdminEventListenerException
   {
       // System.out.println("====>TransactionsRecoveryEventListener.processEvent"+
       //     "request for recovery transactions on server="+
       //     event.getServerName() + " logDir=" + event.getLogDir());

        String currentServer = ApplicationServer.getServerContext().getInstanceName();

        boolean delegated = (!currentServer.equals(event.getServerName()));

        //call recover method.
        try {
            JTSMonitorMBean.recover(delegated, event.getLogDir());
        } catch (Exception ex) {
            if (ex.getMessage() != null)
                throw new AdminEventListenerException(ex.getMessage());
            else
                throw new AdminEventListenerException(sm.getString("transaction.unexpected_exception_in_recover-transactions"));
        }
   }
}
