/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.http.HSVirtualServerEvent;
import com.sun.enterprise.admin.event.http.HSVirtualServerEventListener;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.web.PEWebContainer;

import java.util.ArrayList;
import java.util.Set;

import org.apache.catalina.LifecycleException;


/**
 * This class handles dynamic reconfiguration notification related to 
 * virtual-server creation, update and deletion.
 *
 * @author Jean-Francois Arcand
 */ 
public class VirtualServerReconfig implements HSVirtualServerEventListener{
   
    private static PEWebContainer webContainer = 
                                 ((PEWebContainer)PEWebContainer.getInstance());
    
    /**
     * Create a new virtual-server.
     */
    public void handleCreate(HSVirtualServerEvent event)
                                            throws AdminEventListenerException {
        
        if ( webContainer == null) return;       
           
        try{                                                          
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
                                    
            if ( config == null) return;
            
            ConfigAdd configAdd = null;
            ArrayList configChangeList = event.getConfigChangeList();
            VirtualServer vsBean = null;
            String xpath = null;
            Server serverBean = ServerBeansFactory.getServerBean(configContext);
            ElementProperty elementProperty = null;
            Object object;
            Object configObject;
            
            for (int i=0; i < configChangeList.size(); i++){
                configObject = configChangeList.get(i);

                if ( configObject instanceof ConfigAdd) {
                    configAdd = (ConfigAdd)configObject;
                    xpath = configAdd.getXPath();
                    if( xpath != null){
                        object = configContext.exactLookup(xpath);                   
                        // always a VirtualServer first and then ElementProperty.
                        if ( object instanceof VirtualServer){
                            vsBean = (VirtualServer)object;                           
                            webContainer.createHost(vsBean,configContext,true);
                        } else if (object instanceof ElementProperty) {
                            // Lookup the server beans.
                            xpath = xpath.substring(0,xpath.lastIndexOf("/"));
                            vsBean = (VirtualServer)configContext.exactLookup(xpath);                       
                            elementProperty = (ElementProperty)object;
                            webContainer.updateHostProperties(
                                       vsBean, 
                                       elementProperty.getName(),
                                       elementProperty.getValue(),
                                       config.getHttpService());
                        }
                    }
                }
            }
        } catch (Exception ex) {
           throw new AdminEventListenerException(ex);
        } 
    }
    
    
    /**
     * Update an existing virtual-server.
     */
    public void handleUpdate(HSVirtualServerEvent event)
                                            throws AdminEventListenerException {  
        
        if ( webContainer == null) return;       
           
        try{                                            
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            
            if ( config == null) return;
            
            ConfigChange configChange = null;
            ArrayList<ConfigChange> configChangeList = 
                                                    event.getConfigChangeList();
            VirtualServer vsBean = null;
            String xpath = null;
            Server serverBean = ServerBeansFactory.getServerBean(configContext);
            ElementProperty elementProperty = null;
            Object object;           

            for (int i=0; i < configChangeList.size(); i++){
                configChange = configChangeList.get(i);
                
                xpath = configChange.getXPath();
                if( xpath != null){
                    object = configContext.exactLookup(xpath);
                    if ( object instanceof VirtualServer){
                        vsBean = (VirtualServer)object;
                        webContainer.updateHost(vsBean, 
                                                config.getHttpService(), 
                                                serverBean);
                    } else if (object instanceof ElementProperty) {
                        // Lookup the server beans.
                        xpath = xpath.substring(0,xpath.lastIndexOf("/"));
                        vsBean = (VirtualServer)configContext.exactLookup(xpath);                       
                        elementProperty = (ElementProperty)object;
                        webContainer.updateHostProperties(
                                   vsBean, 
                                   elementProperty.getName(),
                                   elementProperty.getValue(),
                                   config.getHttpService());
                    }
                }
            }
        } catch (Exception ex) {
           throw new AdminEventListenerException(ex);
        } 
    }
    
    
    /**
     * Delete an existing virtual-server. 
     *
     * Implementation note: we cannot use the same approach used when
     * handling create/update event since the element is deleted before this
     * method is invoked (strange behaviour). Instead we need to find by 
     * ourself which virtual-server has been deleted.
     */
    public void handleDelete(HSVirtualServerEvent event) 
                                            throws AdminEventListenerException {                                        
         
        if ( webContainer == null) return;       
           
        try{
            if( event != null){
                ConfigContext configContext = event.getConfigContext();
                Config config = ServerBeansFactory.getConfigBean(configContext);
                
                if ( config!= null) 
                    webContainer.deleteHost(config.getHttpService());    
            }
        } catch( Exception ex){
           throw new AdminEventListenerException(ex);
        }    
    }     
}


