/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

import com.sun.logging.LogDomains;
import com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Registry of JAXWS RuntimeEndpointInfo of endpoints.
 * @author Manisha Umbarje
 */
public class JAXWSRuntimeEpiRegistry {
    
    private static JAXWSRuntimeEpiRegistry registry = null;
    
    //Mapping of of ContextRoot to RuntimeEndpointInfo for all URLs within contextRoot
    private Map store;
    Logger logger = LogDomains.getLogger(LogDomains.WEB_LOGGER);
    
    /** Creates a new instance of JAXWSServletUtil */
    private JAXWSRuntimeEpiRegistry() {
        store = new HashMap();
    }
    
    public static JAXWSRuntimeEpiRegistry getInstance() {
        if(registry == null)
            registry = new JAXWSRuntimeEpiRegistry();
        return registry;
    }
    
    public void addRuntimeEndpointInfo(String contextRoot, String urlPattern, 
            RuntimeEndpointInfo info) {
        if (contextRoot == null)
            contextRoot = "";
        
        ContextRuntimeEndpointInfo contextRtInfo = 
                (ContextRuntimeEndpointInfo)store.get(contextRoot);
        
        if(contextRtInfo == null) {
            contextRtInfo = new ContextRuntimeEndpointInfo(contextRoot);
        }
        
        contextRtInfo.addRuntimeEndpointInfo(urlPattern, info);
        store.put(contextRoot, contextRtInfo);
    }
    
     public RuntimeEndpointInfo getRuntimeEndpointInfo(String contextRoot,
             String path, String urlPattern ) {
         ContextRuntimeEndpointInfo serviceInfo = 
                (ContextRuntimeEndpointInfo)store.get(contextRoot);
        
        if(serviceInfo == null)
             return null;
        
         return serviceInfo.getRuntimeEndpointInfo(path, urlPattern);
     }
  
     public void removeRuntimeInfo(String contextRoot) {
         if(contextRoot == null)
             contextRoot = "";
         
         ContextRuntimeEndpointInfo serviceInfo = 
                (ContextRuntimeEndpointInfo)store.get(contextRoot);
        
        if(serviceInfo == null)
             return ;
        
        store.remove(contextRoot);
     }
    class  ContextRuntimeEndpointInfo {
        String contextRoot;
        Map fixedUrlPatternEndpoints;
        List<RuntimeEndpointInfo> pathUrlPatternEndpoints;

        ContextRuntimeEndpointInfo(String contextRoot) {
            this.contextRoot = contextRoot;
            fixedUrlPatternEndpoints = new HashMap();
            pathUrlPatternEndpoints = new ArrayList();
        }

        void addRuntimeEndpointInfo(String urlPattern, RuntimeEndpointInfo info) {
            if (urlPattern.indexOf("*.") != -1) {
                // cannot deal with implicit mapping right now
                logger.log(Level.WARNING, "Implicit mapping not supported; ignoring for now");
            } else if (urlPattern.endsWith("/*")) {
                pathUrlPatternEndpoints.add(info);
            } else {
                if (fixedUrlPatternEndpoints.containsKey(urlPattern)) {
                    logger.log(Level.WARNING, "Duplicate endpoint URL " + urlPattern + " in service " + 
                            ((com.sun.xml.ws.server.RuntimeEndpointInfo)info).getName());
                } else {
                    fixedUrlPatternEndpoints.put(urlPattern, info);
                }
            }
        }

        RuntimeEndpointInfo getRuntimeEndpointInfo(String path, String urlPattern) {
            RuntimeEndpointInfo result = (RuntimeEndpointInfo) fixedUrlPatternEndpoints.get(path);
            if (result == null) {
                
                // This loop is unnecessary.Essentially what it is doing to always
                // return the first element from pathUrlPatternEndpoints
                // TO DO clean up after SCF required
                for (Iterator iter = pathUrlPatternEndpoints.iterator(); iter.hasNext();) {
                    RuntimeEndpointInfo candidate = (RuntimeEndpointInfo) iter.next();
                    if (path.startsWith(getValidPathForEndpoint(urlPattern))) {
                        result = candidate;
                        break;
                    }
                }
            }
            return result;
        }

         private String getValidPathForEndpoint(String s) {
            if (s.endsWith("/*")) {
                return s.substring(0, s.length() - 2);
            } else {
                return s;
            }
        }
    }
}