/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.*;
import javax.servlet.http.*;

import com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl;
import com.sun.enterprise.webservice.monitoring.HttpResponseInfoImpl;
import com.sun.enterprise.webservice.monitoring.ThreadLocalInfo;
import com.sun.enterprise.webservice.monitoring.JAXWSEndpointImpl;
import com.sun.enterprise.webservice.monitoring.WebServiceTesterServlet;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import com.sun.enterprise.webservice.monitoring.EndpointType;
import com.sun.enterprise.webservice.monitoring.EndpointImpl;

import com.sun.enterprise.Switch;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;

import com.sun.enterprise.util.InjectionManagerImpl;

import com.sun.enterprise.security.jauth.ServerAuthConfig;

import com.sun.xml.ws.spi.runtime.WSRtObjectFactory;
import com.sun.xml.ws.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.ws.spi.runtime.WSConnection;
import com.sun.xml.ws.spi.runtime.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.MessageContext.Scope;
import javax.xml.ws.soap.SOAPBinding;

// catalina
import org.apache.catalina.Loader;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * The JAX-WS dispatcher servlet.
 *
 */
public class JAXWSServlet extends HttpServlet {

    private static Logger logger = LogDomains.getLogger(LogDomains.WEB_LOGGER);    
    private ServletContext servletContext;
    
    private WebServiceEndpoint endpoint_;
    
    private WSRtObjectFactory rpcFactory_;

    private String urlPattern;
    
    private String contextRoot;

    private boolean jaxwsInitDone = false;
    
    private WebServiceEngineImpl wsEngine_;
    private JAXWSEndpointImpl endpointImpl_;  

    ClassLoader classLoader;
    
    private com.sun.xml.ws.server.Tie tie = new com.sun.xml.ws.server.Tie();

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            this.servletContext = servletConfig.getServletContext();
            wsEngine_ = WebServiceEngineImpl.getInstance();
            // Register endpoints here
            doInit(servletConfig);
        } catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        JAXWSRuntimeEpiRegistry.getInstance().removeRuntimeInfo(contextRoot);
        try {
            (new WsUtil()).doPreDestroy(endpoint_, classLoader);
        } catch (Throwable t) {
            logger.log(Level.WARNING, "@PreDestroy lifecycle call failed for service" 
                    + endpoint_.getName(), t);
        }
        wsEngine_.removeHandler(endpoint_);
    }

    protected void doPost(HttpServletRequest request,
                          HttpServletResponse response)
        throws ServletException {

        if ("Tester".equalsIgnoreCase(request.getQueryString())) {            
            Endpoint endpt = wsEngine_.getEndpoint(request.getRequestURL().toString());
            if (endpt!=null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
                WebServiceTesterServlet.invoke(request, response,
                        endpt.getDescriptor());
                return;
            }
        }        
                
        // check if we need to trace this...        
        String messageId=null;
        if (wsEngine_.getGlobalMessageListener()!=null) {
            Endpoint endpt = wsEngine_.getEndpoint(request.getRequestURL().toString());                
            messageId = wsEngine_.preProcessRequest(endpt);  
            if (messageId!=null) {
                ThreadLocalInfo config = new ThreadLocalInfo(messageId, request);
                wsEngine_.getThreadLocal().set(config);
            }
        }

        // We need to call runtimeEndpointInfo.init at the very first doPost call for this service
        if(!jaxwsInitDone) {
            // come to this synchronized only if the flag is not set
            synchronized(this) {
                // multiple clients could have requested the service at once and
                // all of them could be waiting at this syncronized block;
                // so do one more check to ensure that jaxws.init is done only once
                if(!jaxwsInitDone) {
                    String path = request.getRequestURI().substring(request.getContextPath().length());
                    JAXWSRuntimeEpiRegistry.getInstance().getRuntimeEndpointInfo(contextRoot, urlPattern, path).init();
                    jaxwsInitDone = true;
                }
            }
        }
        
        // lookup registered URLs, create JAXRPC connection object and forward the request
        try {
            RuntimeEndpointInfo targetEndpoint = getEndpointFor(request);
            if (targetEndpoint != null) {
                WSConnection connection = rpcFactory_.createWSConnection(request, response);
                WebServiceContext wsCtxt = targetEndpoint.getWebServiceContext();
                MessageContext msgCtxt = rpcFactory_.createMessageContext();
                msgCtxt.put(MessageContext.SERVLET_CONTEXT, servletContext);
                msgCtxt.setScope(MessageContext.SERVLET_CONTEXT, Scope.APPLICATION);
                msgCtxt.put(MessageContext.SERVLET_REQUEST, request);
                msgCtxt.setScope(MessageContext.SERVLET_REQUEST, Scope.APPLICATION);
                msgCtxt.put(MessageContext.SERVLET_RESPONSE, response);
                msgCtxt.setScope(MessageContext.SERVLET_RESPONSE, Scope.APPLICATION);
                msgCtxt.put(EndpointImpl.MESSAGE_ID, messageId);
                msgCtxt.put(MessageContext.HTTP_REQUEST_METHOD, request.getMethod());
                msgCtxt.setScope(MessageContext.HTTP_REQUEST_METHOD, Scope.APPLICATION);
                if (request.getQueryString() != null) {
                    msgCtxt.put(MessageContext.QUERY_STRING, request.getQueryString());
                    msgCtxt.setScope(MessageContext.QUERY_STRING, Scope.APPLICATION);
                }
                if (request.getPathInfo() != null) {
                    msgCtxt.put(MessageContext.PATH_INFO, request.getPathInfo());
                    msgCtxt.setScope(MessageContext.PATH_INFO, Scope.APPLICATION);
                }
                msgCtxt.put(MessageContext.HTTP_REQUEST_HEADERS, connection.getHeaders());
                msgCtxt.setScope(MessageContext.HTTP_REQUEST_HEADERS, Scope.APPLICATION);
                wsCtxt.setMessageContext(msgCtxt);
                tie.handle(connection, targetEndpoint);
            } else {
                throw new ServletException("Service not found");
            }
        } catch(Throwable t) {
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        } 

        if (messageId!=null) {
            HttpResponseInfoImpl info = new HttpResponseInfoImpl(response);
            wsEngine_.postProcessResponse(messageId, info);
        }
    }

    protected void doGet(HttpServletRequest request, 
                         HttpServletResponse response)
        throws ServletException {
        
        if ("Tester".equalsIgnoreCase(request.getQueryString())) {
            
            Endpoint endpt = wsEngine_.getEndpoint(request.getRequestURL().toString());
            if (endpt!=null && Boolean.parseBoolean(endpt.getDescriptor().getDebugging())) {
                Loader loader = (Loader) endpt.getDescriptor().getBundleDescriptor().getExtraAttribute("WEBLOADER");
                if (loader != null) {
                    endpt.getDescriptor().getBundleDescriptor().setClassLoader(loader.getClassLoader());
                    endpt.getDescriptor().getBundleDescriptor().removeExtraAttribute("WEBLOADER");
                }
                WebServiceTesterServlet.invoke(request, response,
                        endpt.getDescriptor());
                return;
            }
        }
        
        // normal WSDL retrieval invocation
        WsUtil wsUtil = new WsUtil();
        try {
            wsUtil.handleGet(request, response, endpoint_);
        } catch(Exception e) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" +
               endpoint_.getEndpointName() + "' HTTP GET error", e);
        }
    }
    
    private void doInit(ServletConfig servletConfig) throws ServletException {
        String servletName = "unknown";

        try {
            InvocationManager invManager = 
                Switch.getSwitch().getInvocationManager();
            ComponentInvocation inv = invManager.getCurrentInvocation();
            Object containerContext = inv.getContainerContext();

            WebBundleDescriptor webBundle = (WebBundleDescriptor)
                Switch.getSwitch().getDescriptorFor(containerContext);
            classLoader = Thread.currentThread().getContextClassLoader();
            servletName = servletConfig.getServletName();
            contextRoot = webBundle.getContextRoot();
            WebComponentDescriptor webComponent = 
                webBundle.getWebComponentByCanonicalName(servletName);

            if( webComponent != null ) {
                WebServicesDescriptor webServices = webBundle.getWebServices();
                Collection endpoints =                     
                    webServices.getEndpointsImplementedBy(webComponent);
                // Only 1 endpoint per servlet is supported, even though
                // data structure implies otherwise. 
                endpoint_ = (WebServiceEndpoint) endpoints.iterator().next();

                // need to invoke the endpoint lifecylcle 
		endpointImpl_ = (JAXWSEndpointImpl)
                    wsEngine_.createHandler((SystemHandlerDelegate)null, endpoint_);

                registerEndpoint();

            } else {
                throw new ServletException(servletName + " not found");
            }
        } catch(Throwable t) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" +
                       servletName + "' failure", t);
            ServletException se = new ServletException();
            se.initCause(t);
            throw se;
        }        
    }

    private void registerEndpoint()
        throws Exception {

        //
        // Convert J2EE deployment descriptor information into 
        // JAXRPC endpoint data structure
        //

        rpcFactory_ = WSRtObjectFactory.newInstance();
        RuntimeEndpointInfo endpointInfo = 
	    rpcFactory_.createRuntimeEndpointInfo();
        
        Object serviceEndpoint = 
                Class.forName(endpoint_.getServletImplClass(), true, classLoader).newInstance();

        // Inject @Resource for the endpoint
        new InjectionManagerImpl().injectInstance(serviceEndpoint);
        
        // For JAXWS Servlet endpoint both implementor class and the implementor are the same
        endpointInfo.setImplementorClass(Class.forName(endpoint_.getServletImplClass(), true, classLoader));
        endpointInfo.setImplementor(serviceEndpoint);

        // Set webservice context here
        // If the endpoint has a WebServiceContext with @Resource then
        // that has to be used
        WebServiceContext wsc = null;
        WebBundleDescriptor bundle = (WebBundleDescriptor)endpoint_.getBundleDescriptor();
        Iterator<ResourceReferenceDescriptor> it = bundle.getResourceReferenceDescriptors().iterator();
        while(it.hasNext()) {
            ResourceReferenceDescriptor r = it.next();
            if(r.isWebServiceContext()) {
                try {
                    javax.naming.InitialContext ic = new javax.naming.InitialContext();
                    wsc = (WebServiceContext) ic.lookup("java:comp/env/" + r.getName());
                } catch (Throwable t) {} // Swallowed intentionally
            }
        }
        if(wsc == null) {
            wsc = new WebServiceContextImpl();
        }
        endpointInfo.setWebServiceContext(wsc);

        // For web components, this will be relative to the web app
        // context root.  Make sure there is a leading slash.
        String uri = endpoint_.getEndpointAddressUri();
        urlPattern = uri.startsWith("/") ? uri : "/" + uri;

        // Set wsdl and catalog info
        java.net.URL catalogURL = null;
        File catalogFile = new File(endpoint_.getBundleDescriptor().getDeploymentDescriptorDir() +
                File.separator + "jax-ws-catalog.xml");
        if(catalogFile.exists()) {
            catalogURL = catalogFile.toURL();
        }
        endpointInfo.setWsdlInfo(endpoint_.getWebService().getWsdlFileUrl(),
                rpcFactory_.createEntityResolver(catalogURL));
        
        // Set Service name and port name 
        endpointInfo.setServiceName(endpoint_.getServiceName());
        endpointInfo.setPortName(endpoint_.getWsdlPort());
        
        // Create Binding and Set the System handler delegate here
        endpointInfo.setBinding(rpcFactory_.createBinding(endpoint_.getProtocolBinding()));
        
        // If BindingId is SOAPXXHTTP_MTOM_BINDING, enable MTOM 
        WsUtil wsu = new WsUtil();
        wsu.setMtom(endpointInfo.getBinding(), endpoint_);
        
        // Process handlers
        wsu.configureJAXWSServiceHandlers(endpoint_, endpointInfo);

	SystemHandlerDelegate delegate =
	    JAXWSSystemHandlerDelegateFactory.getServletDelegate(endpoint_);

	// set the appropriate delegate in the SOAPMessageDispatcher
	if (endpointImpl_ != null) {
	    endpointImpl_.setParent(delegate);
	    endpointInfo.getBinding().setSystemHandlerDelegate(endpointImpl_);
	} else {
	    endpointInfo.getBinding().setSystemHandlerDelegate(delegate);
	}

        registerEndpointUrlPattern(endpointInfo);
        wsu.doPostConstruct(endpointInfo.getImplementorClass(),
                serviceEndpoint);
    }   
    
    private void registerEndpointUrlPattern(RuntimeEndpointInfo info) {
        JAXWSRuntimeEpiRegistry.getInstance().
                addRuntimeEndpointInfo(contextRoot, urlPattern,info);
    }
    
    private RuntimeEndpointInfo getEndpointFor(HttpServletRequest request) {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        return JAXWSRuntimeEpiRegistry.getInstance().
                getRuntimeEndpointInfo(contextRoot, urlPattern, path);
    }
    
}
