/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PortInvocationHandler.java
 *
 * Created on June 15, 2005, 3:18 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package com.sun.enterprise.webservice;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

/**
 * Temporary invocation handler to intercept all Port invocations and assess the 
 * necessary access permissions.
 * 
 * @author Jerome Dochez
 */
public class PortInvocationHandler implements InvocationHandler {
    
    Object target; 
    
    /** Creates a new instance of PortInvocationHandler */
    public PortInvocationHandler() {
    }
    
    public void setTarget(Object target) {
        this.target = target;
    }
    
    public Object invoke(Object proxy, final Method m, final Object[] args) {
        try {
            final Method toInvoke = target.getClass().getMethod(m.getName(), m.getParameterTypes());
            return AccessController.doPrivileged(new PrivilegedExceptionAction() {
                public Object run() throws Exception {
                    return toInvoke.invoke(target, args);
                }
            });
        } catch(Exception e) {            
            throw new RuntimeException(e);
        }
    }
}
