/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;

/**
 * Base class for EJB 3.0 session bean tests.
 * @author Vikas Awasthi
 */
public abstract class SessionBeanTest extends EjbTest {
    
    public abstract Result check(EjbSessionDescriptor descriptor) ;
    protected ComponentNameConstructor compName = null;
    protected Result result = null;
    
    public Result check(EjbDescriptor descriptor) {
        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor(); 
        if (descriptor instanceof EjbSessionDescriptor) 
            return check((EjbSessionDescriptor) descriptor);
        
        addNaDetails(result, compName);
        result.notApplicable(smh.getLocalString
                ("com.sun.enterprise.tools.verifier.tests.ejb.ejb30.SessionBeanTest.notApplicable",
                "Test apply only to Session Bean components"));
        return result;
    }
}
