/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.*;

import java.util.Collection;
import java.util.Map;

/** 
 * Methods used in method permission element of the deployment descriptor
 * must be methods defined in the enterprise bean's component and/or home 
 * interface.
 */
public class MethodPermissionMethodExists extends MethodsExist implements EjbCheck { 

    /** 
     * Methods used in method permission element of the deployment descriptor
     * must be methods defined in the enterprise bean's remote and/or home 
     * interface.
     * 
     * @param descriptor the Enterprise Java Bean deployment descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();

        if ((descriptor instanceof EjbSessionDescriptor)  ||
                (descriptor instanceof EjbEntityDescriptor)) {
            Map<MethodPermission,
                    Collection<MethodDescriptor>> permissionedMethods = descriptor.getMethodPermissionsFromDD();
        
            if (permissionedMethods!=null) {

                for (MethodPermission methodPermission : permissionedMethods.keySet()) 
                    for (MethodDescriptor methodDescriptor : permissionedMethods.get(methodPermission)) 
                        checkMethodStyles(methodDescriptor, descriptor);
            }
        }

        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                    "Valid method permission method(s) found."));
        }
        return result;
    }
}

