/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;

/**
 * @author Sudipto Ghosh
 *
 */
public class AbstractSchemaNameIsValidJavaIdentifier extends EjbTest implements EjbCheck{
    /**
     * For an entity-bean the abstract-schema-name must be a valid Java identifier.
     * See ejb specification 2.1 section 10.3.13
     * @param descriptor the Enterprise Java Bean deployment descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor){
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        String abstractSchema = null;

        if(descriptor instanceof EjbEntityDescriptor) {
            if (((EjbEntityDescriptor)descriptor).getPersistenceType().equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE)) {
                if (((EjbCMPEntityDescriptor) descriptor).getCMPVersion()==EjbCMPEntityDescriptor.CMP_2_x) {
                    abstractSchema = ((EjbCMPEntityDescriptor)descriptor).getAbstractSchemaName();
                    if(abstractSchema!=null) {
                        boolean isJavaIdentifier=true;
                        boolean startChar=Character.isJavaIdentifierStart(abstractSchema.charAt(0));
                        if (startChar) {
                            for(int i=1;i<abstractSchema.length();i++)
                                if(!Character.isJavaIdentifierPart(abstractSchema.charAt(i))) {
                                    isJavaIdentifier=false;
                                    break;
                                }
                        } else {
                            isJavaIdentifier=false;
                        }
                        if(isJavaIdentifier) {
                            result.addGoodDetails(smh.getLocalString
                                    ("tests.componentNameConstructor",
                                            "For [ {0} ]",
                                            new Object[] {compName.toString()}));
                            result.passed(smh.getLocalString
                                    (getClass().getName() + ".passed",
                                            "abstract-schema-name [ {0} ] within bean [ {1} ] is a valid java identifier",
                                            new Object[] {abstractSchema, descriptor.getName()}));
                        }else{
                            result.addErrorDetails(smh.getLocalString
                                    ("tests.componentNameConstructor",
                                            "For [ {0} ]",
                                            new Object[] {compName.toString()}));
                            result.failed(smh.getLocalString
                                    (getClass().getName() + ".failed",
                                            "abstract-schema-name [ {0} ] within bean [ {1} ] is not a valid java identifier",
                                            new Object[] {abstractSchema, descriptor.getName()}));
                        }
                    }
                }
            }
        }
        if(abstractSchema==null){
            result.addNaDetails(smh.getLocalString
                    ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
            result.notApplicable(smh.getLocalString
                    (getClass().getName() + ".notApplicable",
                            "abstract-schema-name is not defined or this is not applicable for this bean"));
        }
        return result;
    }
}
