/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 * Container-managed persistent fields related tests superclass 
 *
 * @author  Jerome Dochez
 * @version 
 */
abstract public class CmpFieldTest extends CMPTest {


    /**
     * run an individual verifier test of a declated cmp field of the class
     *
     * @param entity the descriptor for the entity bean containing the cmp-field
     * @param f the descriptor for the declared cmp field
     * @param c the class owning the cmp field
     * @parma r the result object to use to put the test results in
     * 
     * @return true if the test passed
     */
    protected abstract boolean runIndividualCmpFieldTest(Descriptor entity, Descriptor f, Class c, Result r);
    
    /** 
     *
     * Container-managed persistent fields test, iterates over all declared
     * cmp fields and invoke the runIndividualCmpFieldTest nethod
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbCMPEntityDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        Class c = loadEjbClass(descriptor, result);
        if (c!=null) {
            Descriptor persistentField;
	    boolean oneFailed = false;
            
            Set persistentFields = descriptor.getPersistenceDescriptor().getCMPFields();
            Iterator iterator = persistentFields.iterator();
	    if (iterator.hasNext()) {	  	
		while (iterator.hasNext()) {
		    persistentField = (Descriptor)iterator.next();
		    boolean status  = runIndividualCmpFieldTest(descriptor, persistentField, c, result);
		    if (!status) 
			oneFailed=true;                       
		    
		}
		if (oneFailed) {
		    result.setStatus(Result.FAILED);
		} else { 
		    result.setStatus(Result.PASSED);
		}
	    }	    
	    else { 
		result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		result.notApplicable(smh.getLocalString
				     ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmpFieldTest.notApplicable",
				      "Not Applicable : The EJB has no CMP fields declared",
				      new Object[] {})); 
	    }
	} 
        return result;
    }
}
