/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf.localintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfacePublic;

import java.util.Set;

/** 
 * Declare local interface as public interface test.  
 * All enterprise bean local interfaces must be declared as public.
 * @author Sheetal Vartak
 */
public class EjbLocalInterfacePublic extends InterfacePublic { 
    
    protected Set<String> getInterfaceNames(EjbDescriptor descriptor) {
        Set<String> intfs = descriptor.getLocalBusinessClassNames();
        if(descriptor.getLocalClassName() != null)
            intfs.add(descriptor.getLocalClassName());
        return intfs;
    }
}
