/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * url-pattern element must not contain New Line (NL) or Carriage Return (CR)
 * In the schema j2ee_1_4.xsd it states that
       The url-patternType contains the url pattern of the mapping.
        It must follow the rules specified in Section 11.2 of the
        Servlet API Specification. This pattern is assumed to be in
        URL-decoded form and must not contain CR(#xD) or LF(#xA).
        If it contains those characters, the container must inform
        the developer with a descriptive error message.
 */
//This test won't be exercised now as DOL already has this test (see bug#4903530)
//But we should have it so that if any day DOL removes that test, we would catch it.
public class URLPatternContainsCRLF extends URLPattern { 

    protected void checkUrlPatternAndSetResult(String urlPattern, Descriptor descriptor, Result result, ComponentNameConstructor compName){
        if (urlPattern == null) return; //some other test takes care of this.
        // In Ascii table, Line Feed (LF) decimal value is 10 and Carriage Return (CR) decimal value is 13
        final int LF = 10, CR = 13;
        if (urlPattern.indexOf(CR)!=-1 || urlPattern.indexOf(LF)!=-1) { 
            oneFailed=true;
            result.failed(smh.getLocalString
                                   ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
            result.addErrorDetails (smh.getLocalString
                                         (getClass().getName() + ".failed",
                                          "url-pattern [ {0} ] within [ {1} ] contains a carriage return or line feed char",
                                          new Object[] {urlPattern, descriptor.getName()}));
        } else {
            result.passed(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
            result.addGoodDetails (smh.getLocalString
                                    (getClass().getName() + ".passed",
                                     "url-pattern [ {0} ] within [ {1} ] does not contain carriage return or line feed char",
                                     new Object[] {urlPattern, descriptor.getName()}));
        }
    }
}
