/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import java.io.*;
import java.net.URL;

/* 
 *   @class.setup_props: ; 
 */ 

/*  
 *   @testName: check  
 *   @assertion_ids:  JSR109_WS_50; 
 *   @test_Strategy: 
 *   @class.testArgs: Additional arguments (if any) to be passed when execing the client  
 *   @testDescription: The wsdl-file element specifies a location of the WSDL description of the 
 *   service. The location is relative to the root of the module. The WSDL description may be a 
 *   partial WSDL, but must at least include the portType and binding elements.
 */

public class WSDLFileCheck extends WSClientTest implements WSClientCheck {

    /**
     * @param descriptor the WebServices  descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check (ServiceReferenceDescriptor descriptor) {

        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        InputStream deploymentEntry=null;

        // wsdl file
        if (descriptor.hasWsdlFile()) {
            String wsdlUri = descriptor.getWsdlFileUri();
            URL url = null;
            try {
                url = new URL(wsdlUri);
            } catch(java.net.MalformedURLException e) {
                // don't care, will eventuall fail below
            }
            if (url != null) {
                if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) {
                    return result;
                }
            }
            try {
                String uri = getAbstractArchiveUri(descriptor);
                FileArchive arch = new FileArchive();
                arch.open(uri);
                deploymentEntry = arch.getEntry(wsdlUri);

                if (deploymentEntry == null) {
                    //result.fail,
                    result.addErrorDetails(smh.getLocalString ("tests.componentNameConstructor",
                            "For [ {0} ]", new Object[] {compName.toString()}));
                    result.failed(smh.getLocalString (getClass().getName() + ".failed",
                            "WSDL file does not exist in the archive at uri [{0}].",
                            new Object[] {wsdlUri}));
                }
                else {
                    //result.pass
                    result.addGoodDetails(smh.getLocalString ("tests.componentNameConstructor",
                            "For [ {0} ]", new Object[] {compName.toString()}));
                    result.passed(smh.getLocalString (getClass().getName() + ".passed",
                            "WSDL file exists in the archive at uri [{0}].",
                            new Object[] {wsdlUri}));

                }
            }catch (Exception e) {
                // result.fail
                result.addErrorDetails(smh.getLocalString
                        ("com.sun.enterprise.tools.verifier.tests.webservices.Error",
                                "Error: Unexpected error occurred [ {0} ]",
                                new Object[] {e.getMessage()}));
            }
            finally {
                try {
                    if (deploymentEntry != null)
                        deploymentEntry.close();
                }catch (IOException e) {}
            }

        }
        else {
            //result.notapplicable since no wsdl specified
            result.addNaDetails(smh.getLocalString
                    ("tests.componentNameConstructor", "For [ {0} ]",
                            new Object[] {compName.toString()}));
            result.notApplicable(smh.getLocalString
                    ( getClass().getName() + ".notapp",
                            "Not applicable since Service Client does not have a WSDL file specified."));

        }

        return result;
    }
 }

