/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.web;

import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

/**
 * @author Sudipto Ghosh
 */
public class FunctionDescriptor {
    Node node;
    public FunctionDescriptor(Node n){
        this.node = n;
    }

    public String getFunctionClass(){
        NodeList n1 = node.getChildNodes();
        int i = 0;
        String className = null;
        for (int k = 0; k < n1.getLength(); k++) {
            String name = n1.item(k).getNodeName();
            if (name == "function-class") { // NOI18N
                className = n1.item(k).getFirstChild().getNodeValue();
            }
        }
        return className;
    }

    public String getFunctionSignature() {
        NodeList n1 = node.getChildNodes();
        int i = 0;
        String signature = null;
        for (int k = 0; k < n1.getLength(); k++) {
            String name = n1.item(k).getNodeName();
            if (name == "function-signature") // NOI18N
                signature = n1.item(k).getFirstChild().getNodeValue();
        }
        return signature;
    }

}
